#include <bits/stdc++.h>

using namespace std;

typedef long long ll;
typedef long double ld;

#define sz(x) ((int) (x).size())
#define pb push_back
#define mp make_pair
#define fi first
#define se second

#define NAME "e"

typedef struct node* pnode;

#define left asdasdasd
#define right asdasdasdasdsad

struct node
{
	int key, prior;
	pnode left, right;
	
	node(int x): key(x), prior(rand()), left(0), right(0) {}
	
	~node()
	{
		if (left) delete left;
		if (right) delete right;
	}
};

void split(pnode root, pnode &left, pnode &right, int key)
{
	if (!root) return void(left = right = 0);
	if (root->key < key)
		split(root->right, root->right, right, key), left = root;
	else
		split(root->left, left, root->left, key), right = root;
}

void merge(pnode &root, pnode left, pnode right)
{
	if (!left || !right) return void(root = left ? left : right);
	if (left->prior < right->prior)
		merge(left->right, left->right, right), root = left;
	else
		merge(right->left, left, right->left), root = right;
}

void insert(pnode &root, int y)
{
	pnode left = 0, right = 0;
	split(root, left, right, y);
	merge(root, left, new node(y));
	merge(root, root, right);
}

bool has(pnode &root, int x)
{
	pnode left = 0, middle = 0, right = 0;
	split(root, left, middle, x);
	bool res = left != nullptr;
	merge(root, left, right);
	return res;
}

struct tree
{
	tree *left, *right;
	pnode s;
	int tl, tr;
	
	tree(int l, int r): s(nullptr), tl(l), tr(r)
	{
		if (l == r)
		{
			left = right = nullptr;
			return;
		}
		int m = (l + r) / 2;
		left = new tree(l, m);
		right = new tree(m + 1, r);
	}
	
	~tree()
	{
		delete s;
		if (left) delete left;
		if (right) delete right;
	}
	
	void add(int x, int y)
	{
		//cerr << tl << " " << tr << " " << x << " " << y << endl;
		if (tl <= x && x <= tr)
			insert(s, y);
		if (tl == x && tr == x) return;
		int m = (tl + tr) / 2;
		if (x <= m) left->add(x, y);
		else right->add(x, y);
	}
	
	bool ask(int x, int y)
	{
		if (tl > x) return false;
		if (tr <= x) return has(s, y);
		return left->ask(x, y) || right->ask(x, y);
	}
};

const int maxn = 120000;

pair< pair<int, int>, pair<int, int> > a[maxn];
int n;
	
void solve()
{
	scanf("%d", &n);
	for (int i = 0; i < n; ++i)
	{
		scanf("%d%d%d", &a[i].first.first, &a[i].first.second, &a[i].second.first),
		a[i].second.second = i;
		a[i].first.first--;
		a[i].first.second--;
		a[i].second.first--;
	}
	sort(a, a + n);
	tree *t = new tree(0, n - 1);
	int ans = 0;
	for (int i = 0; i < n; ++i)
	{
		if (!t->ask(a[i].first.second, a[i].second.first))
			++ans;
		t->add(a[i].first.second, a[i].second.first);
	}
	delete t;
	t = 0;
	printf("%d\n", ans);
}

int main()
{
	#ifdef LOCAL
	assert(freopen(NAME ".in", "r", stdin));
	#endif // LOCAL
	int t;
	scanf("%d", &t);
	for (int i = 0; i < t; ++i) solve();
	#ifdef LOCAL
	cerr << "Time: " << double(clock()) / CLOCKS_PER_SEC << "\n";
	#endif // LOCAL
	return 0;
}
